define(["sitecore", "/sitecore/shell/client/Sitecore/ExperienceEditor/Commands/Coveo/ExperienceEditorShim.js"], function (Sitecore, ExperienceEditor) {
    function toggleDebugMode(activated) {
        window.top.scCoveoShowDebugInformation(activated); 
    }

    Sitecore.Commands.CoveoToggleDebugMode = {
        canExecute: function (context) {
            if (typeof(window.top.scCoveoShowDebugInformation) !== "undefined") {
                toggleDebugMode(context.button.get("isChecked") == "1");
                return true;
            } else {
                return false;
            }
        },
        execute: function (context) {
            ExperienceEditor.PipelinesUtil.generateRequestProcessor("ExperienceEditor.ToggleRegistryKey.Toggle", function (response) {
                var isChecked = response.responseValue.value ? "1" : "0";
                response.context.button.set("isChecked", isChecked);
                toggleDebugMode(isChecked == "1");
            }, { value: context.button.get("registryKey") }).execute(context);
        }
    };
});